/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.i18n;

import com.google.common.base.Preconditions;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class PropertiesResourceBundle
extends ResourceBundle {
    private final Map<String, String> properties = new HashMap<String, String>();

    public PropertiesResourceBundle(Properties properties) {
        for (String k : properties.stringPropertyNames()) {
            this.properties.put(k, properties.getProperty(k));
        }
    }

    protected static Properties readProperties(CharSource charSource) throws IOException {
        Properties properties = new Properties();
        try (Reader r = null;){
            r = charSource.openStream();
            properties.load(r);
        }
        return properties;
    }

    @Override
    protected Object handleGetObject(String key) {
        Preconditions.checkNotNull(key);
        return this.properties.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.parent != null ? new RbEnum(this.properties.keySet().iterator(), this.parent.getKeys()) : Collections.enumeration(this.properties.keySet());
    }

    static class RbEnum
    implements Enumeration<String> {
        private Iterator<String> iter;
        private Enumeration<String> parent;

        RbEnum(Iterator<String> iter, Enumeration<String> parent) {
            this.iter = iter;
            this.parent = parent;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext() || this.parent.hasMoreElements();
        }

        @Override
        public String nextElement() {
            return this.iter.hasNext() ? this.iter.next() : this.parent.nextElement();
        }
    }
}

